/*******************************************************************************
This code replicates appendix figure: International Transmission of FED Hikes: Emerging
vs Advanced Economies (GK surprises), smallest sample

We run IV-Local projections in smallest sample (FX debt sample)

For confidentiality issues, we don't provide UIP data, nor IAPOC of FX debt data. 
*******************************************************************************/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
set graphics on
//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  

use "LP_data", clear

/*******************************************************************************
Check units
*******************************************************************************/
replace i_treasury_12m_avg_US=i_treasury_12m_avg_US/100
/*******************************************************************************
Drop hard pegs
*******************************************************************************/
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"

/*******************************************************************************
Set parameters of LP
*******************************************************************************/
global lags=4 
global horizon=10 
global conf=90 //confidence levels 
global cinorm = invnormal($conf/100)
global instrument "ff4"

/*
Get RHS:
1. Lags of dependent variable 
2. Lags of gdp growth and inflation differentials 
3. Lags of the shockvar 
4. Lags of the instrument
*/
xtset IFS_code time_q 
g lcpi=ln(cpi_IFS)
g inflationIFS=D.lcpi //inflation q to q 

//winsor inflation:
winsor2 inflationIFS, replace cuts(4 96)

g ler=ln(ER_avg_IFS) 
g g_er=D.ler //ER q to q

g lgdp=ln(rGDPsa_weo)

foreach var of varlist g_gdp_final inflationIFS {
	g double var1=`var' if IFS_code==111
	bys time_q: egen double max=max(var1) 
	g double `var'_diff=`var'-max 
	drop var1 max 
	}

xtset IFS_code time_q 
//Lags 
foreach var of varlist lgdp  g_gdp_final_diff inflationIFS_diff i_treasury_12m_avg_US g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US /*ln_theta_12m_treasury*/  $instrument  { 
	forv l=1/$lags { 
		g `var'_l`l'=l`l'.`var'

	}
}
/*
Get the LHS: 
*/	
//Leads 
foreach var of varlist lgdp g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US /*ln_theta_12m_treasury*/{ 
	forv h=0/$horizon{ 
		g `var'_`h'=f`h'.`var'
		
	}	
}

// Time span: 
keep if time_q>=tq(1990q1) 

/*******************************************************************************
LP IV regression
*******************************************************************************/
cd "../../Figure A2"
global colorHigh "red" 
global colorLow "blue"

***Smallest sample
keep if iapoc_sample==1 
keep if fx_sample==1 

/*
Obtain coefficient to normalize 
*/
//drop USA
drop if IFS_code==111

ivreghdfe i_policy_US_0 i_policy_US_l1-i_policy_US_l4 i_treasury_12m_avg_US_l1-i_treasury_12m_avg_US_l4 *g_gdp_final_diff_l* *inflationIFS_diff_l* (i_treasury_12m_avg_US=${instrument}), absorb(IFS_code) 
global b_norm=_b[i_treasury_12m_avg_US]

//Define controls 
global x="*g_gdp_final_diff_l* *inflationIFS_diff_l* *i_treasury_12m_avg_US_l* ${instrument}_l*"

/*
GDP levels
*/
mat drop _all
mat coef=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1

	//EM 
	ivreghdfe lgdp_`h' *lgdp_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:GDP}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(lgdp_EM,replace)
graph save "lgdpEM.gph", replace
graph export "lGDP.pdf", replace
rm "lgdpEM.gph"
cap n drop Quarter EM_d coef ub lb Zero
//Save results to excel 
mat A=(coef)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A2.xlsx", sheet("GDP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb


/*
12m UIP deviation in treasury 
*/
/*
mat drop _all
mat coef=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	
	//EM 
	ivreghdfe ln_theta_12m_treasury_`h' $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:12m UIP deviation}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(uip_EM,replace)
graph save "uipEM.gph", replace 
graph export "UIP.pdf", replace
rm "uipEM.gph"
cap n drop Quarter EM_d coef ub lb Zero
//Save results to excel 
mat A=(coef)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A2.xlsx", sheet("UIP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb
*/
/*
Exchange rate q/q growth
*/
mat drop _all
mat coef=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe g_er_`h' *g_er_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	

	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Exchange Rate (Local/USD)}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(g_er_EM,replace)
graph save "g_er_EM.gph", replace 
graph export "g_er.pdf", replace
rm "g_er_EM.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A2.xlsx", sheet("ER", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb

/*
Capital flows to GDP
*/
mat drop _all
mat coef=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe all_DB_inflow_AHKS_GDP_2023_`h' *all_DB_inflow_AHKS_GDP_2023_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Capital Inflows to GDP}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(inflow_EM,replace)
graph save "capflowsEM.gph", replace
graph export "flows.pdf", replace
rm "capflowsEM.gph"
//Save results to excel 
cap n drop Quarter EM_d coef ub lb Zero

mat A=(coef)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A2.xlsx", sheet("Capflows", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb
*/

